<table class="w-full border-collapse border border-gray-300 text-sm">
    <thead class="bg-gray-100 dark:bg-gray-800">

        <tr>
            <th rowspan="2" class="border">#</th>
            <th rowspan="2" class="border">Date</th>
            <th rowspan="2" class="border">By Account</th>
            <th rowspan="2" class="border">Description</th>
            <th class="border" colspan="3">AFN Balance</th>
            <th class="border" colspan="3">USD Balance</th>
        </tr>
        <tr>
            <th class="border">Debit</th>
            <th class="border">Credit</th>
            <th class="border">Balance</th>
            <th class="border">Debit</th>
            <th class="border">Credit</th>
            <th class="border">Balance</th>
        </tr>
    </thead>
    <tbody>
        
        <tr class="font-bold">
            <td colspan="4" class="text-center">Old Balance</td>
            <td></td>
            <td></td>
            <td><?php echo e(number_format($accOpeningAfn, 2)); ?></td>
            <td></td>
            <td></td>
            <td><?php echo e(number_format($accOpeningUsd, 2)); ?></td>
        </tr>
        <?php
            $last_afn = 0;
            $last_usd = 0;
        ?>

        <?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td class="border"><?php echo e($row['no']); ?></td>
                <td class="border"><?php echo e($row['date']); ?></td>
                <td class="border"><?php echo e($row['by_account']); ?></td>
                <td class="border"><?php echo e($row['description']); ?></td>
                <td class="border"><?php echo e($row['afn_debit']); ?></td>
                <td class="border"><?php echo e($row['afn_credit']); ?></td>
                <td class="border"><?php echo e($row['afn_balance']); ?></td>
                <td class="border"><?php echo e($row['usd_debit']); ?></td>
                <td class="border"><?php echo e($row['usd_credit']); ?></td>
                <td class="border"><?php echo e($row['usd_balance']); ?></td>
            </tr>
            <?php
                $last_afn = (float) str_replace(',', '', $row['afn_balance']);
                $last_usd = (float) str_replace(',', '', $row['usd_balance']);
            ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
    <tfoot class="bg-gray-100 dark:bg-gray-800">
        <tr>
            <td colspan="4" class="border text-center">Totals</td>
            <td class="border"><?php echo e(number_format($accTotalAfnDebit, 2)); ?></td>
            <td class="border"><?php echo e(number_format($accTotalAfnCredit, 2)); ?></td>
            <td class="border">
                <?php
                    $amnt = $last_afn;
                ?>
                <?php echo e($amnt < 0 ? 'Payable: ' . number_format(abs($amnt), 2) : 'Receivable: ' . number_format($amnt, 2)); ?>

            </td>

            <td class="border"><?php echo e(number_format($accTotalUsdDebit, 2)); ?></td>
            <td class="border"><?php echo e(number_format($accTotalUsdCredit, 2)); ?></td>
            <td class="border">
                <?php
                    $amnt = $last_usd;
                ?>
                <?php echo e($amnt < 0 ? 'Payable: ' . number_format(abs($amnt), 2) : 'Receivable: ' . number_format($amnt, 2)); ?>

            </td>
        </tr>
    </tfoot>
</table>
<?php /**PATH D:\wamp\www\LaravelPHP\GoldPlus\resources\views\ReportElems\account-ledger-table.blade.php ENDPATH**/ ?>