<table class="w-full border-collapse border border-gray-300 text-sm">
    <thead class="bg-gray-100 dark:bg-gray-800">
        <tr>
            <th rowspan="2" class="border border-gray-300">#</th>
            <th rowspan="2" class="border border-gray-300">Account Name</th>
            <th rowspan="2" class="border border-gray-300">Phone</th>
            <th colspan="2" class="border border-gray-300">Balance AFN</th>
            <th colspan="2" class="border border-gray-300">Balance USD</th>
        </tr>
        <tr>
            <th class="border border-gray-300">Debit</th>
            <th class="border border-gray-300">Credit</th>
            <th class="border border-gray-300">Debit</th>
            <th class="border border-gray-300">Credit</th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $acc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $afn = (float) $acc['balance_afn'];
                $usd = (float) $acc['balance_usd'];
                $afn_debit = $afn > 0 ? $afn : 0;
                $afn_credit = $afn < 0 ? abs($afn) : 0;
                $usd_debit = $usd > 0 ? $usd : 0;
                $usd_credit = $usd < 0 ? abs($usd) : 0;
            ?>
            <tr>
                <td class="border border-gray-300"><?php echo e($i + 1); ?></td>
                <td class="border border-gray-300"><?php echo e($acc['name']); ?></td>
                <td class="border border-gray-300"><?php echo e($acc['phone']); ?></td>
                <td class="border border-gray-300"><?php echo e($afn_debit ? number_format($afn_debit, 2) : ''); ?></td>
                <td class="border border-gray-300"><?php echo e($afn_credit ? number_format($afn_credit, 2) : ''); ?></td>
                <td class="border border-gray-300"><?php echo e($usd_debit ? number_format($usd_debit, 2) : ''); ?></td>
                <td class="border border-gray-300"><?php echo e($usd_credit ? number_format($usd_credit, 2) : ''); ?></td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
    <tfoot class="bg-gray-100 dark:bg-gray-800">
        <?php
            $totalAfnDebit = $results->sum(fn($r) => max((float) $r['balance_afn'], 0));
            $totalAfnCredit = $results->sum(fn($r) => max(-(float) $r['balance_afn'], 0));
            $totalUsdDebit = $results->sum(fn($r) => max((float) $r['balance_usd'], 0));
            $totalUsdCredit = $results->sum(fn($r) => max(-(float) $r['balance_usd'], 0));

            $netAfn = $totalAfnDebit - $totalAfnCredit;
            $netUsd = $totalUsdDebit - $totalUsdCredit;
        ?>
        <tr>
            <td class="border border-gray-300" colspan="3">Total Debit / Credit</td>
            <td class="border border-gray-300"><?php echo e(number_format($totalAfnDebit, 2)); ?></td>
            <td class="border border-gray-300"><?php echo e(number_format($totalAfnCredit, 2)); ?></td>
            <td class="border border-gray-300"><?php echo e(number_format($totalUsdDebit, 2)); ?></td>
            <td class="border border-gray-300"><?php echo e(number_format($totalUsdCredit, 2)); ?></td>
        </tr>
        <tr>
            <td class="border border-gray-300" colspan="3">Net Balance</td>
            <td class="border border-gray-300" colspan="2" 
                style="color: <?php echo e($netAfn < 0 ? 'red' : 'green'); ?>">
                <?php echo e($netAfn < 0 ? 'Payable: ' : 'Receivable: '); ?><?php echo e(number_format(abs($netAfn), 2)); ?> AFN
            </td>
            <td class="border border-gray-300" colspan="2"
                style="color: <?php echo e($netUsd < 0 ? 'red' : 'green'); ?>">
                <?php echo e($netUsd < 0 ? 'Payable: ' : 'Receivable: '); ?><?php echo e(number_format(abs($netUsd), 2)); ?> USD
            </td>
        </tr>
    </tfoot>
</table>
<?php /**PATH D:\wamp\www\LaravelPHP\GoldPlus\resources\views\ReportElems\account-retrieval-table.blade.php ENDPATH**/ ?>