
<?php if($selectedTradeType === 'purchase'): ?>
    <table class="w-full border-collapse border border-gray-300 text-sm">
        <thead class="bg-gray-100 dark:bg-gray-800  font-bold">
            <tr>
                <th class="border px-2">#</th>
                <th class="border px-2">Date</th>
                <th class="border px-2">Account</th>
                <th class="border px-2">Item</th>
                <th class="border px-2">Qty (g)</th>
                <th class="border px-2">Price</th>
                <th class="border px-2">Currency</th>
                <th class="border px-2">Purchase Value</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="border px-2"><?php echo e($row['no']); ?></td>
                    <td class="border px-2"><?php echo e($row['date']); ?></td>
                    <td class="border px-2"><?php echo e($row['account']); ?></td>
                    <td class="border px-2"><?php echo e($row['item']); ?></td>
                    <td class="border px-2"><?php echo e($row['qty']); ?></td>
                    <td class="border px-2"><?php echo e($row['price']); ?></td>
                    <td class="border px-2"><?php echo e($row['currency']); ?></td>
                    <td class="border px-2"><?php echo e($row['purchase_value']); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
        <tfoot class="bg-gray-100 dark:bg-gray-800 font-bold">
            <tr>
                <td colspan="4" class=" px-2">Total</td>
                <td class="px-2"><?php echo e(number_format($results->sum(fn($r) => (float) $r['qty']), 2)); ?></td>
                <td></td>
                <td></td>
                <td class="px-2"><?php echo e(number_format($results->sum(fn($r) => (float) $r['purchase_value']), 2)); ?>

                </td>
            </tr>
        </tfoot>
    </table>
<?php else: ?>
    <table class="w-full border-collapse border border-gray-300 text-sm">
        <thead class="bg-gray-100 dark:bg-gray-800">
            <tr>
                <th class="border px-2">#</th>
                <th class="border px-2">Date</th>
                <th class="border px-2">Account</th>
                <th class="border px-2">Type</th>
                <th class="border px-2">Item</th>
                <th class="border px-2">Qty (g)</th>
                <th class="border px-2">Price</th>
                <th class="border px-2">Currency</th>
                <th class="border px-2">Sales Value</th>
                <th class="border px-2">Cost / Unit</th>
                <th class="border px-2">Total Cost</th>
                <th class="border px-2">Gross Profit</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="border px-2"><?php echo e($row['no']); ?></td>
                    <td class="border px-2"><?php echo e($row['date']); ?></td>
                    <td class="border px-2"><?php echo e($row['account']); ?></td>
                    <td class="border px-2"><?php echo e(ucfirst($row['type'])); ?></td>
                    <td class="border px-2"><?php echo e($row['item']); ?></td>
                    <td class="border px-2"><?php echo e($row['qty']); ?></td>
                    <td class="border px-2"><?php echo e($row['price']); ?></td>
                    <td class="border px-2"><?php echo e($row['currency']); ?></td>
                    <td class="border px-2"><?php echo e($row['sales_value']); ?></td>
                    <td class="border px-2"><?php echo e($row['cost_per_unit']); ?></td>
                    <td class="border px-2"><?php echo e($row['total_cost_of_sales']); ?></td>
                    <td class="border px-2"><?php echo e($row['gross_profit']); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
        <tfoot class="bg-gray-100 dark:bg-gray-800 font-bold">
            <tr>
                <td colspan="5" class=" px-2">Total</td>
                <td class="px-2"><?php echo e(number_format($results->sum(fn($r) => (float) $r['qty']), 2)); ?></td>
                <td></td>
                <td></td>
                <td class="px-2"><?php echo e(number_format($results->sum(fn($r) => (float) $r['sales_value']), 2)); ?>

                </td>
                <td></td>
                <td class="px-2">
                    <?php echo e(number_format($results->sum(fn($r) => (float) $r['total_cost_of_sales']), 2)); ?></td>
                <td class="px-2"><?php echo e(number_format($results->sum(fn($r) => (float) $r['gross_profit']), 2)); ?>

                </td>
            </tr>
        </tfoot>
    </table>
<?php endif; ?>
<?php /**PATH D:\wamp\www\LaravelPHP\GoldPlus\resources\views\ReportElems\gold-trade-table.blade.php ENDPATH**/ ?>