<x-filament-panels::page>

    <style>
        th,
        td {
            padding-left: 0.5rem;
            padding-right: 0.5rem;
            padding-top: 0.25rem;
            padding-bottom: 0.25rem;
        }
    </style>

    <div class="p-4 rounded ">

        <div class="border-b mb-4">
            <div class="flex space-x-2">
                @foreach ($tabs as $key => $label)
                    <button wire:click="$set('activeTab', '{{ $key }}'); @this.results = collect();"
                        class="px-4 py-2 rounded-t-md {{ $activeTab === $key ? 'bg-primary-600 text-white' : 'bg-gray-100 dark:bg-gray-700 dark:text-gray-300' }}">
                        {{ $label }}
                    </button>
                @endforeach
            </div>
        </div>


        {{ $this->form }}



    </div>



    <div class="p-4 shadow rounded-xl space-y-4">

        <div>
            @php
                $from = $fromDate ? \Carbon\Carbon::parse($fromDate)->format('Y-m-d') : '-';
                $to = $toDate ? \Carbon\Carbon::parse($toDate)->format('Y-m-d') : '-';
                $accName = $selectedAccountId ? \App\Models\Account::find($selectedAccountId)?->name : '-';
                $itemName = $selectedItemId ? \App\Models\Item::find($selectedItemId)?->name : '-';
            @endphp


            @if ($activeTab === 'journal')
                <h3 class="text-lg font-bold mt-4 mb-2 text-center">Journal Report</h3>
                <p class="text-center text-sm mb-4">{{ $this->getSelectedDateRange() }}</p>
                @include('ReportElems.journal-table')
            @elseif ($activeTab === 'stock')
                <h3 class="text-lg font-bold mt-4 mb-2 text-center">Stock Report</h3>
                <p class="text-center text-sm mb-4">As of: {{ $this->getToDateFormatted() }}</p>
                @include('ReportElems.stock-table')
            @elseif ($activeTab === 'item_ledger')
                <h3 class="text-lg font-bold mt-4 mb-2 text-center">Item Ledger Report</h3>
                <p class="text-center text-sm mb-4">
                    {{ $this->getSelectedDateRange() }} | Item: {{ $this->getSelectedItemName() }}
                </p>
                @include('ReportElems.item-ledger-table')
            @elseif ($activeTab === 'account_ledger')
                <h3 class="text-lg font-bold mt-4 mb-2 text-center">Account Ledger Report</h3>
                <p class="text-center text-sm mb-4">
                    {{ $this->getSelectedDateRange() }} | Account: {{ $this->getSelectedAccountName() }}
                </p>
                @include('ReportElems.account-ledger-table')
            @elseif ($activeTab === 'account_retreval')
                <h3 class="text-lg font-bold mt-4 mb-2 text-center">Account Balances Report</h3>
                <p class="text-center text-sm mb-4">
                    As of: {{ $this->getToDateFormatted() }}
                </p>
                @include('ReportElems.account-retrieval-table')
            @elseif ($activeTab === 'gold_trade')
                <h3 class="text-lg font-bold mt-4 mb-2 text-center">{{ $this->getSelectedTradeType() }}</h3>
                <p class="text-center text-sm mb-4">
                    {{ $this->getSelectedDateRange() }} | Item:
                    {{ $this->getSelectedItemName() }} | Account: {{ $this->getSelectedAccountName() }}
                </p>
                @include('ReportElems.gold-trade-table')
            @elseif ($activeTab === 'profit_report')
                <h3 class="text-lg font-bold mt-4 mb-2 text-center">Profit Report</h3>
                <p class="text-center text-sm mb-4">{{ $this->getSelectedDateRange() }}</p>
                @include('ReportElems.profit-report-table')
            @endif
        </div>


    </div>



</x-filament-panels::page>
