 <table class="w-full border-collapse border border-gray-300 text-sm">
     <thead class="bg-gray-100 dark:bg-gray-800">
         <tr>
             <th class="border border-gray-300">#</th>
             <th class="border border-gray-300">Item Name</th>
             <th class="border border-gray-300">Quantity (gm)</th>
             <th class="border border-gray-300">Unit Price (USD)</th>
             <th class="border border-gray-300">Total Price (USD)</th>
         </tr>
     </thead>
     <tbody>
         @php
             $totalQty = 0;
             $totalValue = 0;
         @endphp

         @foreach ($results as $i)
             @php
                 $totalQty += $i['qty'];
                 $totalValue += $i['total_price'];
             @endphp
             <tr>
                 <td class="border border-gray-300 text-center">{{ $i['index'] }}</td>
                 <td class="border border-gray-300">{{ $i['name'] }}</td>
                 <td class="border border-gray-300">{{ $i['qty'] }}</td>
                 <td class="border border-gray-300">{{ $i['unit_price'] }}</td>
                 <td class="border border-gray-300">{{ number_format($i['total_price'], 2) }}</td>
             </tr>
         @endforeach
     </tbody>
     <tfoot class="bg-gray-100 dark:bg-gray-800">
         <tr>
             <td colspan="2" class="border border-gray-300">Totals</td>
             <td class="border border-gray-300">{{ $totalQty }}</td>
             <td class="border border-gray-300">{{ number_format($totalValue / ($totalQty==0? 1: $totalQty), 4) }}</td>
             <td class="border border-gray-300">{{ number_format($totalValue, 4) }}</td>
         </tr>
     </tfoot>
 </table>
