@php
    $gross = $results->get('gross_profit', collect());
    $expenses = $results->get('expenses', collect());
    $net = $results->get('net_profit', collect());

    $totalGrossAfn = $gross->sum('afn');
    $totalGrossUsd = $gross->sum('usd');
    $totalExpensesAfn = $expenses->sum('afn');
    $totalExpensesUsd = $expenses->sum('usd');
@endphp
<div class="flex space-x-6 mb-6 gap-2">
    <table class="w-full border-collapse border border-gray-300 text-sm mb-6">
        <thead class="bg-gray-100 dark:bg-gray-800">
            <tr>
                <th class="border border-gray-300 text-left pl-6" colspan="3">Gross Profit Section</th>
            </tr>
            <tr>
                <th class="border border-gray-300 pl-6">Description</th>
                <th class="border border-gray-300 text-right pr-6">Amount AFN</th>
                <th class="border border-gray-300 text-right pr-6">Amount USD</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($gross as $row)
                <tr>
                    <td class="border border-gray-300 pl-6">{{ $row['desc'] }}</td>
                    <td class="border border-gray-300 text-right pr-6">{{ number_format($row['afn'], 2) }}</td>
                    <td class="border border-gray-300 text-right pr-6">{{ number_format($row['usd'], 2) }}</td>
                </tr>
            @endforeach
        </tbody>
        <tfoot class="bg-gray-100 dark:bg-gray-800 font-bold">
            <tr>
                <td class="border border-gray-300 pl-6">Totals</td>
                <td class="border border-gray-300 text-right pr-6">{{ number_format($totalGrossAfn, 2) }}</td>
                <td class="border border-gray-300 text-right pr-6">{{ number_format($totalGrossUsd, 2) }}</td>
            </tr>
        </tfoot>
    </table>

    <table class="w-full border-collapse border border-gray-300 text-sm mb-6">
        <thead class="bg-gray-100 dark:bg-gray-800">
            <tr>
                <th class="border border-gray-300 text-left pl-6" colspan="3">Expenses Section</th>
            </tr>
            <tr>
                <th class="border border-gray-300 pl-6">Expense Account</th>
                <th class="border border-gray-300 text-right pr-6">Amount AFN</th>
                <th class="border border-gray-300 text-right pr-6">Amount USD</th>
            </tr>
        </thead>
        <tbody>
            @forelse ($expenses as $row)
                <tr>
                    <td class="border border-gray-300 pl-6">{{ $row['desc'] }}</td>
                    <td class="border border-gray-300 text-right pr-6">{{ number_format($row['afn'], 2) }}</td>
                    <td class="border border-gray-300 text-right pr-6">{{ number_format($row['usd'], 2) }}</td>
                </tr>
            @empty
                <tr>
                    <td class="border border-gray-300 text-center" colspan="3">No expenses</td>
                </tr>
            @endforelse
        </tbody>
        <tfoot class="bg-gray-100 dark:bg-gray-800 font-bold">
            <tr>
                <td class="border border-gray-300 pl-6">Totals</td>
                <td class="border border-gray-300 text-right pr-6">{{ number_format($totalExpensesAfn, 2) }}</td>
                <td class="border border-gray-300 text-right pr-6">{{ number_format($totalExpensesUsd, 2) }}</td>
            </tr>
        </tfoot>
    </table>
</div>

<table class="w-full border-collapse border border-gray-300 text-sm mt-3">
    <thead class="bg-gray-100 dark:bg-gray-800">
        <tr>
            <th class="border border-gray-300 text-left pl-6" colspan="3">Net Profit Section</th>
        </tr>
        <tr>
            <th class="border border-gray-300 pl-6">Description</th>
            <th class="border border-gray-300 text-right pr-6">Amount AFN</th>
            <th class="border border-gray-300 text-right pr-6">Amount USD</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($net as $row)
            <tr>
                <td class="border border-gray-300 font-bold pl-6">{{ $row['desc'] }}</td>
                <td class="border border-gray-300 text-right font-bold pr-6">{{ number_format($row['afn'], 2) }}</td>
                <td class="border border-gray-300 text-right font-bold pr-6">{{ number_format($row['usd'], 2) }}</td>
            </tr>
        @endforeach
    </tbody>
</table>
