  <table class="w-full border-collapse border border-gray-300 text-sm">
      <thead class="bg-gray-100 dark:bg-gray-800">
          <tr>
              <th rowspan="2" class="border">#</th>
              <th rowspan="2" class="border">Date</th>
              <th rowspan="2" class="border">Account Name</th>
              <th rowspan="2" class="border">Description</th>
              <th colspan="2" class="border">Afghani (AFN)</th>
              <th colspan="2" class="border">Dollar (USD)</th>
          </tr>
          <tr>
              <th class="border">Debit</th>
              <th class="border">Credit</th>
              <th class="border">Debit</th>
              <th class="border">Credit</th>
          </tr>
      </thead>
      <tbody>


          @foreach ($results as $row)
              <tr>
                  <td class="border">{{ $row['no'] }}</td>
                  <td class="border">{{ date('Y-m-d', strtotime($row['date'])) }}</td>
                  <td class="border">{{ $row['account_name'] }}</td>
                  <td class="border">{{ $row['description'] }}</td>
                  <td class="border ">{{ $row['afn_debit'] }}</td>
                  <td class="border ">{{ $row['afn_credit'] }}</td>
                  <td class="border ">{{ $row['usd_debit'] }}</td>
                  <td class="border ">{{ $row['usd_credit'] }}</td>
              </tr>
          @endforeach
      </tbody>

      <tfoot class="bg-gray-100 dark:bg-gray-800 font-bold">
          <tr>
              <th colspan="4">Total</th>
              <th>{{ number_format($results->sum(fn($r) => (float) $r['afn_credit']), 2) }}</th>
              <th>{{ number_format($results->sum(fn($r) => (float) $r['afn_credit']), 2) }}</th>

              <th>{{ number_format($results->sum(fn($r) => (float) $r['usd_credit']), 2) }}</th>
              <th>{{ number_format($results->sum(fn($r) => (float) $r['usd_credit']), 2) }}</th>

          </tr>
      </tfoot>
  </table>
