
@if ($selectedTradeType === 'purchase')
    <table class="w-full border-collapse border border-gray-300 text-sm">
        <thead class="bg-gray-100 dark:bg-gray-800  font-bold">
            <tr>
                <th class="border px-2">#</th>
                <th class="border px-2">Date</th>
                <th class="border px-2">Account</th>
                <th class="border px-2">Item</th>
                <th class="border px-2">Qty (g)</th>
                <th class="border px-2">Price</th>
                <th class="border px-2">Currency</th>
                <th class="border px-2">Purchase Value</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($results as $row)
                <tr>
                    <td class="border px-2">{{ $row['no'] }}</td>
                    <td class="border px-2">{{ $row['date'] }}</td>
                    <td class="border px-2">{{ $row['account'] }}</td>
                    <td class="border px-2">{{ $row['item'] }}</td>
                    <td class="border px-2">{{ $row['qty'] }}</td>
                    <td class="border px-2">{{ $row['price'] }}</td>
                    <td class="border px-2">{{ $row['currency'] }}</td>
                    <td class="border px-2">{{ $row['purchase_value'] }}</td>
                </tr>
            @endforeach
        </tbody>
        <tfoot class="bg-gray-100 dark:bg-gray-800 font-bold">
            <tr>
                <td colspan="4" class=" px-2">Total</td>
                <td class="px-2">{{ number_format($results->sum(fn($r) => (float) $r['qty']), 2) }}</td>
                <td></td>
                <td></td>
                <td class="px-2">{{ number_format($results->sum(fn($r) => (float) $r['purchase_value']), 2) }}
                </td>
            </tr>
        </tfoot>
    </table>
@else
    <table class="w-full border-collapse border border-gray-300 text-sm">
        <thead class="bg-gray-100 dark:bg-gray-800">
            <tr>
                <th class="border px-2">#</th>
                <th class="border px-2">Date</th>
                <th class="border px-2">Account</th>
                <th class="border px-2">Type</th>
                <th class="border px-2">Item</th>
                <th class="border px-2">Qty (g)</th>
                <th class="border px-2">Price</th>
                <th class="border px-2">Currency</th>
                <th class="border px-2">Sales Value</th>
                <th class="border px-2">Cost / Unit</th>
                <th class="border px-2">Total Cost</th>
                <th class="border px-2">Gross Profit</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($results as $row)
                <tr>
                    <td class="border px-2">{{ $row['no'] }}</td>
                    <td class="border px-2">{{ $row['date'] }}</td>
                    <td class="border px-2">{{ $row['account'] }}</td>
                    <td class="border px-2">{{ ucfirst($row['type']) }}</td>
                    <td class="border px-2">{{ $row['item'] }}</td>
                    <td class="border px-2">{{ $row['qty'] }}</td>
                    <td class="border px-2">{{ $row['price'] }}</td>
                    <td class="border px-2">{{ $row['currency'] }}</td>
                    <td class="border px-2">{{ $row['sales_value'] }}</td>
                    <td class="border px-2">{{ $row['cost_per_unit'] }}</td>
                    <td class="border px-2">{{ $row['total_cost_of_sales'] }}</td>
                    <td class="border px-2">{{ $row['gross_profit'] }}</td>
                </tr>
            @endforeach
        </tbody>
        <tfoot class="bg-gray-100 dark:bg-gray-800 font-bold">
            <tr>
                <td colspan="5" class=" px-2">Total</td>
                <td class="px-2">{{ number_format($results->sum(fn($r) => (float) $r['qty']), 2) }}</td>
                <td></td>
                <td></td>
                <td class="px-2">{{ number_format($results->sum(fn($r) => (float) $r['sales_value']), 2) }}
                </td>
                <td></td>
                <td class="px-2">
                    {{ number_format($results->sum(fn($r) => (float) $r['total_cost_of_sales']), 2) }}</td>
                <td class="px-2">{{ number_format($results->sum(fn($r) => (float) $r['gross_profit']), 2) }}
                </td>
            </tr>
        </tfoot>
    </table>
@endif
