<table class="w-full border-collapse border border-gray-300 text-sm">
    <thead class="bg-gray-100 dark:bg-gray-800">

        <tr>
            <th rowspan="2" class="border">#</th>
            <th rowspan="2" class="border">Date</th>
            <th rowspan="2" class="border">By Account</th>
            <th rowspan="2" class="border">Description</th>
            <th class="border" colspan="3">AFN Balance</th>
            <th class="border" colspan="3">USD Balance</th>
        </tr>
        <tr>
            <th class="border">Debit</th>
            <th class="border">Credit</th>
            <th class="border">Balance</th>
            <th class="border">Debit</th>
            <th class="border">Credit</th>
            <th class="border">Balance</th>
        </tr>
    </thead>
    <tbody>
        {{-- First row: Old balance --}}
        <tr class="font-bold">
            <td colspan="4" class="text-center">Old Balance</td>
            <td></td>
            <td></td>
            <td>{{ number_format($accOpeningAfn, 2) }}</td>
            <td></td>
            <td></td>
            <td>{{ number_format($accOpeningUsd, 2) }}</td>
        </tr>
        @php
            $last_afn = 0;
            $last_usd = 0;
        @endphp

        @foreach ($results as $row)
            <tr>
                <td class="border">{{ $row['no'] }}</td>
                <td class="border">{{ $row['date'] }}</td>
                <td class="border">{{ $row['by_account'] }}</td>
                <td class="border">{{ $row['description'] }}</td>
                <td class="border">{{ $row['afn_debit'] }}</td>
                <td class="border">{{ $row['afn_credit'] }}</td>
                <td class="border">{{ $row['afn_balance'] }}</td>
                <td class="border">{{ $row['usd_debit'] }}</td>
                <td class="border">{{ $row['usd_credit'] }}</td>
                <td class="border">{{ $row['usd_balance'] }}</td>
            </tr>
            @php
                $last_afn = (float) str_replace(',', '', $row['afn_balance']);
                $last_usd = (float) str_replace(',', '', $row['usd_balance']);
            @endphp
        @endforeach
    </tbody>
    <tfoot class="bg-gray-100 dark:bg-gray-800">
        <tr>
            <td colspan="4" class="border text-center">Totals</td>
            <td class="border">{{ number_format($accTotalAfnDebit, 2) }}</td>
            <td class="border">{{ number_format($accTotalAfnCredit, 2) }}</td>
            <td class="border">
                @php
                    $amnt = $last_afn;
                @endphp
                {{ $amnt < 0 ? 'Payable: ' . number_format(abs($amnt), 2) : 'Receivable: ' . number_format($amnt, 2) }}
            </td>

            <td class="border">{{ number_format($accTotalUsdDebit, 2) }}</td>
            <td class="border">{{ number_format($accTotalUsdCredit, 2) }}</td>
            <td class="border">
                @php
                    $amnt = $last_usd;
                @endphp
                {{ $amnt < 0 ? 'Payable: ' . number_format(abs($amnt), 2) : 'Receivable: ' . number_format($amnt, 2) }}
            </td>
        </tr>
    </tfoot>
</table>
