<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Item;
use App\Models\Account;
use App\Models\CurrencyRate;
use App\Models\OpeningBalance;
use App\Models\OpeningStock;
use Illuminate\Support\Facades\Hash;


class InitialDataSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run()
    {
        // User
        User::updateOrCreate(
            ['email' => 'admin@admin.com'],
            ['name' => 'Payenda', 'password' => Hash::make('password')]
        );

        // Items
        $g22 = Item::firstOrCreate(['name' => 'G-22']);
        $g24 = Item::firstOrCreate(['name' => 'G-24']);

        // Accounts
        $qurban = Account::firstOrCreate(['name' => 'Qurban Ali', 'type' => 'customer']);
        $cash = Account::firstOrCreate(['name' => 'Office Cash', 'type' => 'cash']);
        $zain = Account::firstOrCreate(['name' => 'Zainullah', 'type' => 'bank']);
        $khan = Account::firstOrCreate(['name' => 'Khan Ali Khan', 'type' => 'customer']);

        // Opening Balances
        OpeningBalance::create([
            'account_id' => $cash->id,
            'amount' => 10000,
            'currency' => 'AFN',
            'date' => now()
        ]);

        OpeningBalance::create([
            'account_id' => $zain->id,
            'amount' => 500,
            'currency' => 'USD',
            'date' => now()
        ]);

        // Opening Stock
        OpeningStock::create([
            'item_id' => $g22->id,
            'weight_gram' => 100,
            'price_gram' => 294,
            'date' => now()
        ]);

        OpeningStock::create([
            'item_id' => $g24->id,
            'weight_gram' => 150,
            'price_gram' => 293,
            'date' => now()
        ]);

        CurrencyRate::create([
            'currency' => 'USD',
            'rate' => 1,
            'date' => now(),
        ]);

        CurrencyRate::create([
            'currency' => 'AFN',
            'rate' => 70,
            'date' => now(),
        ]);
    }
}
