<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('expenses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('exp_account_id')->constrained('accounts')->cascadeOnDelete();
            $table->foreignId('sn_account_id')->constrained('accounts')->cascadeOnDelete();
            $table->decimal('amount', 20, 2);
            $table->enum('currency', ['AFN', 'USD']);
            $table->decimal('rate', 20, 2)->nullable();
            $table->text('details')->nullable();
            $table->date('date');
            $table->timestamps();
        });
    }
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('expenses');
    }
};
