<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('opening_stocks', function (Blueprint $t) {
            $t->id();
            $t->foreignId('item_id')->constrained('items');
            $t->decimal('weight_gram', 10, 2);
            $t->decimal('price_gram', 10, 2);
            $t->date('date')->default(now());
            $t->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('opening_stocks');
    }
};
