<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('opening_balances', function (Blueprint $t) {
            $t->id();
            $t->foreignId('account_id')->constrained('accounts');
            $t->decimal('amount', 12, 2);
            $t->enum('currency', ['AFN', 'USD']);
            $t->date('date')->default(now());
            $t->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('opening_balances');
    }
};
