<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transactions', function (Blueprint $t) {
            $t->id();
            $t->foreignId('from_account_id')->constrained('accounts');
            $t->foreignId('to_account_id')->constrained('accounts');
            $t->decimal('amount', 12, 2);
            $t->enum('currency', ['AFN', 'USD']);
            $t->text('from_note')->nullable();
            $t->text('to_note')->nullable();
            $t->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};
