<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    // Migration update



    // Migration
    public function up(): void
    {
        Schema::create('currency_exchanges', function (Blueprint $t) {
            $t->id();
            $t->foreignId('source_account_id')->constrained('accounts')->cascadeOnDelete();
            $t->foreignId('exchanger_account_id')->constrained('accounts')->cascadeOnDelete();
            $t->decimal('rate', 10, 4);
            $t->decimal('purchase_amount', 12, 2);
            $t->enum('purchase_currency', ['AFN', 'USD']);
            $t->decimal('sale_amount', 12, 2);
            $t->enum('sale_currency', ['AFN', 'USD']);
            $t->decimal('profit_amount', 12, 2);
            $t->enum('profit_currency', ['AFN', 'USD']);
            $t->text('description')->nullable();
            $t->timestamp('created_at')->useCurrent();
            $t->timestamp('updated_at')->nullable();
        });
    }



    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('currency_exchanges');
    }
};
