<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('gold_trades', function (Blueprint $t) {
            $t->id();
            $t->enum('type', ['purchase', 'sale']);
            $t->foreignId('account_id')->constrained('accounts');
            $t->foreignId('item_id')->constrained('items');
            $t->decimal('weight_gram', 10, 2);
            $t->decimal('price_per_gram', 12, 2);
            $t->enum('currency', ['AFN', 'USD']);
            $t->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('gold_trades');
    }
};
