<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('gold_tests', function (Blueprint $t) {
            $t->id();
            $t->foreignId('customer_id')->constrained('accounts');
            $t->foreignId('item_id')->constrained('items');
            $t->decimal('weight_gram', 10, 2);
            $t->decimal('rate_per_gram', 10, 2)->default(100);
            $t->enum('currency', ['AFN', 'USD'])->default('AFN');
            $t->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('gold_tests');
    }
};
