<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{
    protected $fillable = ['from_account_id', 'to_account_id', 'amount', 'currency', 'from_note', 'to_note'];

    public function from()
    {
        return $this->belongsTo(Account::class, 'from_account_id');
    }

    public function to()
    {
        return $this->belongsTo(Account::class, 'to_account_id');
    }
}
