<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Expense extends Model
{
    protected $fillable = [
        'exp_account_id',
        'sn_account_id',
        'amount',
        'currency',
        'rate',
        'details',
        'date',
    ];

    public function expenseAccount()
    {
        return $this->belongsTo(Account::class, 'exp_account_id');
    }

    public function senderAccount()
    {
        return $this->belongsTo(Account::class, 'sn_account_id');
    }
}
