<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CurrencyRate extends Model
{
  protected $fillable = ['currency', 'rate', 'date'];

  public static function getRate($currency, $date)
  {
    return static::where('currency', $currency)
      ->whereDate('date', '<=', $date)
      ->orderByDesc('date')
      ->value('rate') ?? 1;
  }
}
