<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CurrencyExchange extends Model
{
    protected $fillable = [
        'source_account_id',
        'exchanger_account_id',
        'rate',
        'purchase_amount',
        'purchase_currency',
        'sale_amount',
        'sale_currency',
        'profit_amount',
        'profit_currency',
        'description',
        'created_at',
    ];

    public function sourceAccount()
    {
        return $this->belongsTo(Account::class, 'source_account_id');
    }

    public function exchangerAccount()
    {
        return $this->belongsTo(Account::class, 'exchanger_account_id');
    }
}
