<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Account extends Model
{
    protected $fillable = ['name', 'type', 'phone', 'info'];

    public function sentTx()
    {
        return $this->hasMany(Transaction::class, 'from_account_id');
    }

    public function receivedTx()
    {
        return $this->hasMany(Transaction::class, 'to_account_id');
    }

    public function trades()
    {
        return $this->hasMany(GoldTrade::class);
    }

    public function tests()
    {
        return $this->hasMany(GoldTest::class, 'customer_id');
    }

    public function exchanges()
    {
        return $this->hasMany(CurrencyExchange::class);
    }
}
