<?php

namespace App\Filament\Resources;

use App\Filament\Resources\TransactionResource\Pages;
use App\Filament\Resources\TransactionResource\RelationManagers;
use App\Models\Transaction;
use Filament\Forms;
use Filament\Forms\Components\DatePicker;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Forms\Components\Grid;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Tables\Columns\TextColumn;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class TransactionResource extends Resource
{
    protected static ?string $model = Transaction::class;

    protected static ?string $navigationIcon = 'heroicon-o-arrows-right-left';

    protected static ?string $navigationGroup = 'Financial Section';

    protected static ?int $navigationSort = 2;

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Grid::make(3)->schema([
                    Select::make('from_account_id')->searchable()->preload()
                        ->relationship('from', 'name')->required(),

                    Select::make('to_account_id')->searchable()->preload()
                        ->relationship('to', 'name')->required(),

                    TextInput::make('amount')->autocomplete('off')->numeric()->required(),

                    Select::make('currency')->searchable()->preload()
                        ->options(['AFN' => 'AFN', 'USD' => 'USD'])->required(),

                    DatePicker::make('created_at')->default(now())->required(),


                    Grid::make(2)->schema([
                        Textarea::make('from_note'),
                        Textarea::make('to_note'),
                    ])
                ]),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('id')->sortable(),
                TextColumn::make('from.name')->label('From Account')->sortable()->searchable(),
                TextColumn::make('to.name')->label('To Account')->sortable()->searchable(),
                TextColumn::make('amount')->sortable(),
                TextColumn::make('currency')->sortable(),
                TextColumn::make('from_note')->limit(30),
                TextColumn::make('to_note')->limit(30),
                TextColumn::make('created_at')->date('Y-m-d')->sortable(),
            ])

            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\ViewAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListTransactions::route('/'),
            'create' => Pages\CreateTransaction::route('/create'),
            'edit' => Pages\EditTransaction::route('/{record}/edit'),
        ];
    }
}
