<?php

namespace App\Filament\Resources;

use App\Filament\Resources\OpeningStockResource\Pages;
use App\Filament\Resources\OpeningStockResource\RelationManagers;
use App\Models\GoldTrade;
use App\Models\OpeningStock;
use Filament\Forms;
use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\Grid;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Columns\Summarizers\Sum;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class OpeningStockResource extends Resource
{
    protected static ?string $model = OpeningStock::class;

    protected static ?string $navigationIcon = 'heroicon-o-archive-box';


    protected static ?string $navigationGroup = 'Primary Deffinations';



    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Grid::make(4)->schema([
                    Select::make('item_id')->searchable()->preload()
                        ->relationship('item', 'name')
                        ->required(),
                    TextInput::make('weight_gram')->autocomplete('off')->numeric()->required(),
                    TextInput::make('price_gram')->label('Price/(gr) USD')->autocomplete('off')->numeric()->required(),
                    DatePicker::make('date')->required(),
                ])
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('item.name')->label('Item')->sortable()->searchable(),
                TextColumn::make('weight_gram')->label('Weight (gr)'),
                TextColumn::make('price_gram')->label('Price/(gr)'),
                TextColumn::make('total_price')->label('Total Price')
                    ->getStateUsing(
                        fn(OpeningStock $record) =>
                        $record->weight_gram * $record->price_gram
                    ),
                TextColumn::make('date')->date('Y-m-d'),
            ])

            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\ViewAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListOpeningStocks::route('/'),
            'create' => Pages\CreateOpeningStock::route('/create'),
            'edit' => Pages\EditOpeningStock::route('/{record}/edit'),
        ];
    }
}
