<?php

namespace App\Filament\Resources;

use App\Filament\Resources\OpeningBalanceResource\Pages;
use App\Filament\Resources\OpeningBalanceResource\RelationManagers;
use App\Models\OpeningBalance;
use Filament\Forms;
use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\Grid;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class OpeningBalanceResource extends Resource
{
    protected static ?string $model = OpeningBalance::class;

    protected static ?string $navigationIcon = 'heroicon-o-banknotes';

    
    protected static ?string $navigationGroup = 'Primary Deffinations';



    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Grid::make(3)->schema([
                    Select::make('account_id')->searchable()->preload()
                        ->relationship('account', 'name')
                        ->required(),
                    TextInput::make('amount')->autocomplete('off')->numeric()->required(),
                    Select::make('currency')->searchable()->preload()
                        ->options(['AFN' => 'AFN', 'USD' => 'USD'])
                        ->required(),
                    DatePicker::make('date')->required(),
                ])
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('account.name')->label('Account')->sortable()->searchable(),
                TextColumn::make('amount'),
                TextColumn::make('currency'),
                TextColumn::make('date')->date('Y-m-d'),
            ])

            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\ViewAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListOpeningBalances::route('/'),
            'create' => Pages\CreateOpeningBalance::route('/create'),
            'edit' => Pages\EditOpeningBalance::route('/{record}/edit'),
        ];
    }
}
