<?php

namespace App\Filament\Resources;

use App\Filament\Resources\ExpenseResource\Pages;
use App\Models\Account;
use App\Models\Expense;
use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\Fieldset;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class ExpenseResource extends Resource
{
    protected static ?string $model = Expense::class;

    protected static ?string $navigationIcon = 'heroicon-o-trash';

    protected static ?string $navigationGroup = 'Financial Section';

    protected static ?int $navigationSort = 3;


    public static function form(Form $form): Form
    {
        return $form->schema([
            Fieldset::make('Expense Info')
                ->schema([
                    Select::make('exp_account_id')
                        ->label('Expense Account')
                        ->relationship('expenseAccount', 'name')
                        ->options(Account::where('type', 'expense')->pluck('name', 'id'))
                        ->searchable()->preload()->required(),

                    Select::make('sn_account_id')
                        ->label('Sender Account')
                        ->relationship('senderAccount', 'name')
                        ->options(Account::where('type', 'cash')->pluck('name', 'id'))
                        ->searchable()->preload()->required(),

                    DatePicker::make('date')
                        ->native(false)
                        ->default(now())
                        ->displayFormat('Y-m-d')
                        ->required(),

                ])->columns(3),

            Fieldset::make('Transaction Details')
                ->schema([
                    TextInput::make('amount')->numeric()->required(),
                    Select::make('currency')
                        ->options(['AFN' => 'AFN', 'USD' => 'USD'])
                        ->searchable()->preload()->required(),

                    TextInput::make('rate')->numeric()->required(),
                ])->columns(3),

            Textarea::make('details')
                ->rows(3)
                ->placeholder('Optional notes or purpose of the expense...')
                ->columnSpanFull(),
        ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('date')->sortable()->date(),
                TextColumn::make('expenseAccount.name')->label('Expense A/C')->searchable(),
                TextColumn::make('senderAccount.name')->label('Sender A/C')->searchable(),
                TextColumn::make('amount')->numeric()->sortable(),
                TextColumn::make('currency')->sortable(),
                TextColumn::make('rate')->numeric()->label('Rate')->sortable()->default('-'),
                TextColumn::make('details')->limit(30)->tooltip(fn($r) => $r->details),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListExpenses::route('/'),
            'create' => Pages\CreateExpense::route('/create'),
            'edit' => Pages\EditExpense::route('/{record}/edit'),
        ];
    }
}
