<?php

namespace App\Filament\ReportFuncs;

use App\Models\GoldTrade;
use App\Models\GoldTest;
use Carbon\Carbon;

class TradeReport
{
    public static function generate($from, $to, $type = 'sale', $itemId = '0'): array
    {
        $fromDate = Carbon::parse($from)->startOfDay();
        $toDate = Carbon::parse($to)->endOfDay();

        $results = [];

        if ($type === 'purchase') {
            $query = GoldTrade::where('type', 'purchase')->whereBetween('created_at', [$fromDate, $toDate]);
            if ($itemId !== '0') $query->where('item_id', $itemId);

            $purchases = $query->get();

            foreach ($purchases as $i => $row) {
                $results[] = [
                    'no' => $i + 1,
                    'date' => $row->created_at->format('Y-m-d'),
                    'account' => $row->account?->name ?? $row->account_id,
                    'item' => $row->item?->name ?? $row->item_id,
                    'qty' => round($row->weight_gram, 2),
                    'price' => round($row->price_per_gram, 2),
                    'purchase_value' => round($row->weight_gram * $row->price_per_gram, 2),
                    'currency' => $row->currency,
                ];
            }
        } else {
            $sales = GoldTrade::where('type', 'sale')->whereBetween('created_at', [$fromDate, $toDate]);
            $tests = GoldTest::whereBetween('created_at', [$fromDate, $toDate]);

            if ($itemId !== '0') {
                $sales->where('item_id', $itemId);
                $tests->where('item_id', $itemId);
            }

            $combined = $sales->get()->map(function ($r) {
                return [
                    'no' => 0,
                    'type' => 'sale',
                    'date' => $r->created_at->format('Y-m-d'),
                    'account' => $r->account?->name ?? $r->account_id,
                    'item' => $r->item?->name ?? $r->item_id,
                    'qty' => round($r->weight_gram, 2),
                    'price' => round($r->price_per_gram, 2),
                    'sales_value' => round($r->weight_gram * $r->price_per_gram, 2),
                    'cost_per_unit' => 10,
                    'total_cost_of_sales' =>  round($r->weight_gram * 10, 2),
                    'gross_profit' => round(($r->weight_gram * $r->price_per_gram) - ($r->weight_gram * 10), 2),
                    'currency' => $r->currency,
                ];
            })->concat(
                $tests->get()->map(function ($r) {
                    return [
                        'no' => 0,
                        'type' => 'test',
                        'date' => $r->created_at->format('Y-m-d'),
                        'account' => $r->customer?->name ?? $r->customer_id,
                        'item' => $r->item?->name ?? $r->item_id,
                        'qty' => round($r->weight_gram, 2),
                        'price' => round($r->rate_per_gram, 2),
                        'sales_value' => round($r->weight_gram * $r->rate_per_gram, 2),
                        'cost_per_unit' => 0,
                        'total_cost_of_sales' => 0,
                        'gross_profit' => 0,
                        'currency' => $r->currency,
                    ];
                })
            )->sortBy('date')->values();

            foreach ($combined as $i => $row) {
                $row['no'] = $i + 1;
                $results[] = $row;
            }
        }

        return [
            'results' => $results,
        ];
    }
}
